<?php
/*
 * お知らせ管理システム
 * Copyright (c) 2010-2023 by Crytus All rights reserved.
 *
 * 【注意】このファイルの修正は充分ご注意ください。
 * 修正する前には、必ずバックアップを保存してください。
 * 動作がおかしくなったら元のファイルに戻してください。
 * このファイルの漢字コードはHTMLと同じにしてください。
 *
 * 2024/01/30 同日のお知らせに対応しました
 * 2024/01/30 日付をYYYY/MM/DD形式にしました
 */
ini_set("short_open_tag", "0");
ini_set("magic_quotes_gpc", "0");
ini_set("mbstring.encoding_translation", "0");

// エラー出力の指定
error_reporting (E_ALL & ~E_NOTICE & ~E_WARNING & ~E_STRICT & ~E_DEPRECATED);

// データベースの漢字コード
define("DB_ENCODING", "UTF-8");

// メールの漢字コード(UTF-8かJIS)
define("MAIL_ENCODING", "JIS");

// セッションの開始
session_start();

// スクリプトの漢字コード（このファイルの漢字コードと一致させてください）
//define("SCRIPT_ENCODING", "SJIS");	// Shift-JISの場合先頭の'//'を取ります。
define("SCRIPT_ENCODING", "UTF-8");	// UTF-8の場合先頭の'//'を取ります。

// データベースファイルの場所と名前
$DB_URI = "data/info.sqlite";

$script_encoding = SCRIPT_ENCODING;

// 1ページの件数
if (!defined("PAGE_LIMIT")) {
	define("PAGE_LIMIT", 10);	// 10件
}

// 動作環境チェック
if (!function_exists("mb_convert_encoding")) {
	error_exit("日本語変換処理が使えません。ご確認をお願い致します。");
}
//if (!function_exists("sqlite_open")) {
//	error_exit("簡易データベース(SQLite)が使えません。ご確認をお願い致します。");
//}
if (!class_exists("PDO")) {
	error_exit("簡易データベース(SQLite3)が使えません。ご確認をお願い致します。");
} else {
	$ary = PDO::getAvailableDrivers();
	if (!in_array("sqlite", $ary)) {
		error_exit("簡易データベース(SQLite3)が使えません。ご確認をお願い致します。");
	}
}
if (!file_exists($DB_URI)) {
	error_exit("データファイル（{$DB_URI}）がみつかりません。ご確認をお願い致します。");
}
if (!function_exists("ImageCreateFromString")) {
	error_exit("画像処理が組み込まれていません。ご確認をお願い致します。");
}
if (substr(phpversion(), 0, 1) == "4") {
	error_exit("このシステムはPHP5 が必要です。ご確認をお願い致します。");
}
// 異常終了
function error_exit($msg)
{
	echo '<html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8"></head><body>';
	echo $msg;
	echo "</body></html>";
	exit;
}
//-------------------------------------------------------------
// XSS対策
if (is_array($_REQUEST) && (!$_SESSION["LOGIN"])) {
	foreach ($_REQUEST as $k => $v) {
		if (is_array($v)) {
			foreach ($v as $k2 => $v2) {
				$_REQUEST[$k][$k2] = mb_ereg_replace("<.*>", "", $v2);
			}
		} else {
			$_REQUEST[$k] = mb_ereg_replace("<.*>", "", $_REQUEST[$k]);
		}
	}
}
//
//include("demo.php");
//
$dbh = new PDO("sqlite:" . $DB_URI);

function exec_file($file)
{
	global $setup;
	global $DB_URI;
	global $script_encoding;

	if (file_exists("_files/" . $file)) {
		include_once("_files/" . $file);
	} else {
		$php = load_blob($file);
		if ($php) {
			eval("?>" . $php);
		}
	}
}

// 大きなデータを取り出す
function load_blob($key)
{
	global $dbh;

//echo "load:{$key}<br>";
	$sql = "select seq from file_list where name='{$key}'";
	//$result = sqlite_query($dbh, $sql);
	//$val = sqlite_fetch_all($result);
	$ret = $dbh->query($sql);
	$val = $ret->fetchAll();

	if ($val) {
		$val = $val[0];
		$id = $val["seq"];
		$file = load_db_file($id);
		return $file;
	}
	return false;
}

function load_db_file($id)
{
	global $dbh;

	$data = "";
	$sql = "select contents from file_contents where file_num={$id} order by seq";
	//$result = sqlite_query($dbh, $sql);
	$stmt = $dbh->query($sql);
	while ($ret = $stmt->fetch(PDO::FETCH_ASSOC)) {
		$data .= $ret["contents"];
	}
	return $data;
}

function safeStripSlashes($var) {
	if (is_array($var)) {
		return array_map('safeStripSlashes', $var);
	} else {
		return $var;
	}
}

$act = $_REQUEST["act"];
if (!$act) {
	$act = "index";
}

// バイナリー処理のファイル
$binary = array(
	"png",
	"jpg",
	"gif",
);

if ($act == "file") {
	$file = $_REQUEST["f"];
	if ($file) {
		if (file_exists($file)) {
			$contents = file_get_contents($file);
		} else if (file_exists("_files/" . $file)) {
			$contents = file_get_contents("_files/" . $file);
		} else {
			$contents = load_blob($file);
			$ary = explode(".", $file);
			if (count($ary) > 1) {	// 拡張子あり？
				if (in_array($ary[count($ary)-1], $binary)) {
					$contents = base64_decode($contents);
				}
			}
		}
	}
	header('Content-Type: ' . get_mime_types($file));
	echo $contents;
	exit;
}
// --------------------------------
exec_file("sqlite_db.php");
exec_file("dbaccess.php");

exec_file("cms.php");
exec_file("info.php");
exec_file("info_item.php");
exec_file("image.php");

exec_file("htmltemplate.php");
exec_file("info_core.php");
exec_file("markdown.php");
// --------------------------------
$siteinfo = get_setup();
$data["siteinfo"] = $siteinfo;
//
if (($act == "toiawase")||($act == "toiawase_reinput")) {
	$id = $_REQUEST["id"];
	$item = get_bukken($id);
	if ($id && $item) {
		$data["item"] = $item;
		//
		$mode = $_REQUEST["mode"];
		if ($mode == "form") {
			$name = $_REQUEST["name"];
			$email = $_REQUEST["email"];
			$comment = $_REQUEST["comment"];
			$form["name"] = $name;
			$form["email"] = $email;
			$form["comment"] = $comment;
			$data["form"] = $form;
			if ($name && $email && $comment) {
				$data["mode"] = "confirm";
				$data["confirm"] = "1";
				$_SESSION["form"] = $form;
			} else {
				$msg = array();
				if (!$name) {
					$msg[] = $error_msg1;
				}
				if (!$email) {
					$msg[] = $error_msg2;
				}
				if (!$comment) {
					$msg[] = $error_msg3;
				}
				$data["message"] = join("<br/>", $msg);
				$data["mode"] = "form";
			}
		} else if ($mode == "confirm") {
			$form = $_SESSION["form"];
			$body = $mail_body;
			$body = str_replace("{info_id}", $item["info_id"], $body);
			$body = str_replace("{title}", $item["title"], $body);
			$body = str_replace("{name}", $form["name"], $body);
			$body = str_replace("{email}", $form["email"], $body);
			$body = str_replace("{comment}", $form["comment"], $body);
			// メール送信
			$tmp = $pre_admin . "\n" . $body . "\n\n" . $post_admin;
			sendmail2($from_mail, $admin_mail, $subject_admin, $tmp, null, $from_name);
			$tmp = $form["name"] . "{$mail_sama}\n\n{$pre_user}\n{$body}\n\n{$post_user}";
			sendmail2($from_mail, $form["email"], $subject, $tmp, null, $from_name);
		} else {
			$data["mode"] = "form";
		}
		if ($act == "toiawase_reinput") {
			$data["form"] = $_SESSION["form"];
			$data["mode"] = "form";
		}
		//
		htmltemplate::t_include("toiawase.html", $data);
		exit;
	}
}
if ($act == "detail") {
	if ($_REQUEST["id"]) {
		$_SESSION["newsid"] = $_REQUEST["id"];
	}
	if ($_REQUEST["html"]) {
		header("location: " . $_REQUEST["html"]);
		exit;
	}
}
if ($act == "set_infoid") {
	if ($_REQUEST["id"]) {
		$_SESSION["newsid"] = $_REQUEST["id"];
	}
	exit;
}
if ($act == "get_info") {
	if ($_SESSION["newsid"]) {
		$id = $_SESSION["newsid"];
	}
	if ($_REQUEST["id"]) {
		$id = $_REQUEST["id"];
	}
	if ($id) {
		$item = get_setup(INFO_RSS, $id);
	} else {
		$info = get_newinfo(1);
		$item = $info[0];
	}
	if (substr($item["contents"], 0, 3) == "#md") {
		$item["contents"] = markdown(substr($item["contents"], 3));
	} else {
		$item["contents"] = nl2br($item["contents"]);
	}
	$item["date"] = substr($item["date"], 0, 4) . "/" . substr($item["date"], 5, 2) . "/" . substr($item["date"], 8, 2);
	echo json_encode($item, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
	exit;
}
if ($act == "get_infolist") {
	$max = 10;
	if ($_REQUEST["max"]) {
		$max = $_REQUEST["max"];
	}
	$info = get_newinfo($max);
	if (is_array($info)) {
		echo json_encode($info, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
	}
	exit;
}
// --------------------------------
// トップページ
readfile("index.html");
exit;
// --------------------------------
// お知らせ
function get_newinfo($max=10)
{
	global $DB_URI;

	$sql = "select * from info where open=1 and kind=" . INFO_RSS;
	$inst = DBConnection::getConnection($DB_URI);
	$ret = $inst->search_sql($sql);
	$list = array();
	if ($ret["count"]) {
		foreach ($ret["data"] as $val) {
			$item = get_setup(INFO_RSS, $val["info_id"]);
			$item["id"] = $val["info_id"];
			if ($item["open"]) {
				$item["reg_date"] = $val["reg_date"];
				if (newflag(-1, $item["date"])) {
					$item["new_flag"] = "1";
				}
				if (!$item["date"]) {
					$item["date"] = $item["reg_date"];
				}
				$t = strtotime($item["date"]);
				while (1) {
					if ($list[$t]) {
						$t++;
					} else {
						$list[$t] = $item;
						break;
					}
				}
			}
		}
	}
	// 並べ替え
	$rss = array();
	if ($list) {
		$count = 0;
		krsort($list);
		foreach ($list as $val) {
			$val["date"] = substr($val["date"], 0, 4) . "/" . substr($val["date"], 5, 2) . "/" . substr($val["date"], 8, 2);
			$rss[] = $val;
			$count++;
			if ($count >= $max) {
				break;
			}
		}
	}
	return $rss;
}
// --------------------------------
function page_index($cur, $pages)
{
	$page = array();
	$no = 0;
	if ($cur > 1) {
		$page['prev'] = array('no' => $cur - 1, 'name' => 'PREV', 'link' => 1);
	}
	for ($i = 1; $i <= $pages; $i++) {
		if ($i == $cur) {
			$page['list'][$no] = array('no' => $i, 'name' => $i);
		} else {
			$page['list'][$no] = array('no' => $i, 'name' => $i, 'link' => 1);
		}
		$no++;
	}
	if ($cur < ($pages)) {
		$page['next'] = array('no' => $cur + 1, 'name' => 'NEXT', 'link' => 1);
	}
	return $page;
}

// ファイルの拡張子からMIMEタイプを得る
function get_mime_types($file)
{
	$mime_types = array(
		'txt' => 'text/plain',
		'htm' => 'text/html',
		'html' => 'text/html',
		'php' => 'text/html',
		'css' => 'text/css',
		'js' => 'application/javascript',
		'json' => 'application/json',
		'xml' => 'application/xml',
		'swf' => 'application/x-shockwave-flash',
		'flv' => 'video/x-flv',

		// images
		'png' => 'image/png',
		'jpe' => 'image/jpeg',
		'jpeg' => 'image/jpeg',
		'jpg' => 'image/jpeg',
		'gif' => 'image/gif',
		'bmp' => 'image/bmp',
		'ico' => 'image/vnd.microsoft.icon',
		'tiff' => 'image/tiff',
		'tif' => 'image/tiff',
		'svg' => 'image/svg+xml',
		'svgz' => 'image/svg+xml',

		// archives
		'zip' => 'application/zip',
		'rar' => 'application/x-rar-compressed',
		'exe' => 'application/x-msdownload',
		'msi' => 'application/x-msdownload',
		'cab' => 'application/vnd.ms-cab-compressed',

		// audio/video
		'mp3' => 'audio/mpeg',
		'qt' => 'video/quicktime',
		'mov' => 'video/quicktime',

		// adobe
		'pdf' => 'application/pdf',
		'psd' => 'image/vnd.adobe.photoshop',
		'ai' => 'application/postscript',
		'eps' => 'application/postscript',
		'ps' => 'application/postscript',

		// ms office
		'doc' => 'application/msword',
		'rtf' => 'application/rtf',
		'xls' => 'application/vnd.ms-excel',
		'ppt' => 'application/vnd.ms-powerpoint',

		// open office
		'odt' => 'application/vnd.oasis.opendocument.text',
		'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
	);

	$ary = explode(".", $file);
	if (count($ary) > 1) {	// 拡張子あり？
		if ($mime_types[$ary[count($ary)-1]]) {
			return $mime_types[$ary[count($ary)-1]];
		}
	}
	return "application/octet-stream";	// 不明なファイル
}
function get_filetype($file)
{
	if (substr($file["filetype"], 0, 5) == "audio") {
		return "audio";
	}
	if (substr($file["filetype"], 0, 5) == "video") {
		return "video";
	}
	if (substr($file["filetype"], 0, 5) == "image") {
		return "image";
	}
	$ary = explode(".", $file["name"]);
	if (count($ary) > 1) {
		if (($ary[count($ary) - 1] == "vr") || ($ary[count($ary) - 1] == "VR")) {
			return "panorama";
		}
	}
	return "other";
}
function newflag($new, $date)
{
	if (defined("NEW_DAYS") && NEW_DAYS) {
		$t = intval((time() - strtotime($date)) / 86400);
		if ($new < 0) {
			if ($t < NEW_DAYS) return 1;
		} else if (defined("NEW_OR")) {
			// OR(新着または設定日数以内の場合)
			if ($new || ($t < NEW_DAYS)) return 1;
		} else if (defined("NEW_AND")) {
			// AND(新着かつ設定日数以内の場合)
			if ($new && ($t < NEW_DAYS)) return 1;
		} else {
			// 自動判定のみ
			if ($t < NEW_DAYS) return 1;
		}
	} else {
		// 新着設定のみ
		if ($new > 0) return 1;
	}
	return 0;
}
