<?php
/*
 * CMS管理システム設定ファイル
 * Copyright (c) 2010-2016 by Crytus All rights reserved.
 */
// スクリプトの漢字コード（このファイルの漢字コードと一致させてください）
//define("SCRIPT_ENCODING", "SJIS");	// Shift-JISの場合先頭の'//'を取ります。
define("SCRIPT_ENCODING", "UTF-8");	// UTF-8の場合先頭の'//'を取ります。

// データベースファイルの場所と名前
$db_file = "data/cmsdb.sqlite";
//
$mysql_db = "";
$mysql_server = "";
$mysql_id = "";
$mysql_pass = "";

// MySQL
if ($mysql_db && $mysql_server && $mysql_id && $mysql_pass) {
	$DB_URI = array(
		"db" => "mysql:dbname={$mysql_db};host={$mysql_server}",
		"user" => $mysql_id,
		"password" => $mysql_pass,
	);
}
// SQLite3
if ($db_file) {
	$DB_URI = array(
		"db" => "sqlite:" . $db_file,
		"user" => "",
		"password" => "",
	);
}

// 一覧の1ページあたりの表示件数
define("PAGE_LIMIT", 10);	// 10件

// 自動新着表示の設定
define("NEW_DAYS", 7);		// 自動新着表示の日数。現在は１週間（7）に設定。
define("NEW_AND", 1);

//-------------------------------------------------------------
// 設定
$setup = array(
	"midashi" => "登録情報",
	// 扱う情報の種類。"5"以降も追加可。
	"bukken" => array(
		"1" => "売買物件",
		"2" => "賃貸物件",
		"3" => "店舗物件",
		"4" => "駐車場物件",
),
	// トップページお知らせ件数
	"info_max" => 10,
	// オプション選択肢
	"option_list" => array(
		"" => "",
		"1" => "おすすめ",
		"2" => "ご契約済み",	//管理画面でこのプルダウンが選択された際にご契約済みになる設定です。この行を変更する際は要注意！
		"3" => "キャンペーン中",
		"4" => "オプション4",
		"5" => "オプション5",
		"6" => "オプション6",
		"7" => "オプション7",
		"8" => "オプション8",
		"9" => "オプション9",
		"10" => "オプション10",
	),
// こだわり条件のアイコン設定
	"icons" => array(
		"1" => array(	// 売買物件
			"1" => "",
			"2" => "",
			"3" => "",
			"4" => "",
			"5" => "",
			"6" => "",
			"7" => "",
			"8" => "",
			"9" => "",
			"10" => "",
			"11" => "",
			"12" => "",
			"13" => "",
			"14" => "",
			"15" => "",
			"16" => "",
			"17" => "",
			"18" => "",
			"19" => "",
			"20" => "",
		),
		"2" => array(	// 賃貸物件
			"1" => "icon_new.gif",
			"2" => "icon_reform.gif",
			"3" => "icon_hiatari.gif",
			"4" => "icon_minami.gif",
			"5" => "icon_kado.gif",
			"6" => "icon_p.gif",
			"7" => "icon_pet.gif",
			"8" => "icon_shampoodresser.gif",
			"9" => "icon_shower.gif",
			"10" => "icon_bidet.gif",
			"11" => "icon_kanso.gif",
			"12" => "icon_kyuto.gif",
			"13" => "icon_bs.gif",
			"14" => "icon_aircon.gif",
			"15" => "icon_balcony.gif",
			"16" => "icon_bath_wc.gif",
			"17" => "icon_kitchen_taimen.gif",
			"18" => "icon_oidaki.gif",
			"19" => "icon_niwa.gif",
			"20" => "icon_kitchen_system.gif",
		),
		"3" => array(	// 店舗物件
			"1" => "",
			"2" => "",
			"3" => "",
			"4" => "",
			"5" => "",
			"6" => "",
			"7" => "",
			"8" => "",
			"9" => "",
			"10" => "",
			"11" => "",
			"12" => "",
			"13" => "",
			"14" => "",
			"15" => "",
			"16" => "",
			"17" => "",
			"18" => "",
			"19" => "",
			"20" => "",
		),
		"4" => array(	// 駐車場
			"1" => "icon_seichi.gif",
			"2" => "icon_3no.gif",
			"3" => "",
			"4" => "",
			"5" => "",
			"6" => "",
			"7" => "",
			"8" => "",
			"9" => "",
			"10" => "",
			"11" => "",
			"12" => "",
			"13" => "",
			"14" => "",
			"15" => "",
			"16" => "",
			"17" => "",
			"18" => "",
			"19" => "",
			"20" => "",
		),
	),
);
//--------------------
// メール設定
$from_mail = "";	// メールの送信元
$admin_mail = "";	// 管理者にメールを送信する場合
$from_name = "サンプルサイト";	// 送信元の名称
$subject = "お問合せ";	// メールの件名
$subject_admin = "お問合せがありました";	// 管理者宛てのメールの件名
// メール文面
$pre_user = "次の通りお問い合わせを承りました";		// ユーザー宛ての前文
$post_user = "改めて回答をお送りいたしますので、しばらくお待ちください";	// ユーザー宛ての後文
//
$pre_admin = "次の問合せがありました\n";	// 管理者宛ての前文
$post_admin = "";	// 管理者宛ての後文
$mail_sama = "様";	// 敬称
// 情報問い合わせ
$mail_item = "title,name,email,comment";
$mail_body = "■ID：{info_id}\n" .
	"■物件名称：{title}\n" .
	"■お名前：{name}\n" .
	"■メールアドレス：{email}\n" .
	"■お問い合わせ詳細：\n" .
	"{comment}\n";
// 一般問い合わせ
$mail_item2 = "name,email,comment";
$mail_body2 = "■お名前：{name}\n" .
	"■メールアドレス：{email}\n" .
	"■お問い合わせ詳細：\n" .
	"{comment}\n";
// エラーメッセージ
$error = array(
	"name" => "お名前を入力してください",
	"email" => "メールアドレスを入力してください",
	"comment" => "お問い合わせ内容を入力してください",
);
// ファイル終了
